//ライブラリをインストールします
#include <M5Core2.h>          //M5Core2のパッケージです
#include <BluetoothSerial.h>  //ブルートゥースのパッケージです
#include <FS.h>               //内部データーベース用のパッケージです
#include <SPIFFS.h>           //SPIFFS用のパッケージです

#include "logo2.h"  //画像ファイルです

BluetoothSerial SerialBT;  //ブルートゥースに使うなにかです。よくわかっていません

//グローバル変数置き場

int setting = 0;
int setting_connected = 0;


//最初の処理
void setup() {
  M5.begin();  //m5を使うためのもの
  SPIFFS.begin();
  M5.Axp.ScreenBreath(100);                           // 画面の明るさ7〜12
  M5.Lcd.setRotation(1);                              // 画面を横向きにする
  M5.Lcd.fillScreen(WHITE);                           // 背景色
  M5.Lcd.setSwapBytes(false);                         // 色がおかしい場合に変更する
  M5.Lcd.startWrite();                                //画面表示開始
  M5.Lcd.pushImage(0, 0, imgWidth, imgHeight, logo);  //起動ロゴを表示
  Serial.println("起動しました");
  delay(1000);  //少し待機
  M5.Lcd.endWrite();
  Serial.println("WiFiコンフィグ探知");
  if (SPIFFS.exists("/wifi_credentials.txt")) {  //WiFIの設定が済まされているかどうか
    Serial.println("wifi_credentials.txtが存在します");
    setting = 10;  // 存在する場合、settingを10に設定
  }
  Serial.println("コンフィグ探知終了");
  if (setting == 0) {  //もしも初回起動に動作させるもの
    M5.Lcd.pushImage(0, 0, imgWidth, imgHeight, QR);
    Serial.println("ロゴ表示完了");
    M5.Lcd.endWrite();  //設定用のロゴを表示

    SerialBT.begin("BambooCompost");
    Serial.println("ブルートゥースを開始しました");
  }
}

void loop() {
  Serial.println(setting);
  if (setting == 0) {
    BTSetting();
  }
  if (setting == 1) {
    receiveWiFiSettings();
  }
}

void BTSetting() {
  if (SerialBT.available()) {
    String receivedData = SerialBT.readStringUntil('\n');
    receivedData.trim();
    if (receivedData.equals("connect")) {
      receivedData.trim();
      SerialBT.println("Connect");
      int setting = 1;
      Serial.println("コネクト");
    }
  }
}

void receiveWiFiSettings() {
  // WiFiの設定情報を受信
  String wifiSettings = SerialBT.readStringUntil('\n');
  wifiSettings.trim();

  // カンマで分割
  int separatorIndex = wifiSettings.indexOf(',');
  if (separatorIndex != -1) {
    String ssid = wifiSettings.substring(0, separatorIndex);
    String password = wifiSettings.substring(separatorIndex + 1);

    // SPIFFSにWiFiの設定情報を保存
    saveWiFiCredentials(ssid, password);
  }
}

void saveWiFiCredentials(const String& ssid, const String& password) {
  // SPIFFSにファイルを書き込み
  File file = SPIFFS.open("/wifi_credentials.txt", "w");
  if (file) {
    file.println("SSID=" + ssid);
    file.println("Password=" + password);
    file.close();
    Serial.println("WiFi credentials saved successfully.");
  } else {
    Serial.println("Error saving WiFi credentials to SPIFFS");
  }
}