//ライブラリをインストールします
#include <M5Core2.h>     //M5Core2のライブラリをインクルード
#include <BLEDevice.h>   //ブルートゥースのライブラリをインクルード
#include <BLEServer.h>   //ブルートゥースのライブラリをインクルード
#include <BLE2902.h>     //ブルートゥースのライブラリをインクルード
#include <FS.h>          //内部データーベースのライブラリをインクルード
#include <SPIFFS.h>      //SPIFFSライブラリをインクルード
#include <WiFi.h>        // WiFiライブラリをインクルード
#include "logo.h"        //画像ファイルです
#include <HTTPClient.h>  //HTTP通信用ライブラリ

//グローバル変数置き場
int system_status = 1;  //プログラムステータスを1に設定します
//プログラムステータス説明
//0:通常稼働中です
//1:初期設定のための最初の通信を行います
//2:WiFiを設定します
//10:リセット

int system_status_temp = 1;  //プログラムステータスをの控え
int resetbutton = 0;         //リセットボタンの変数
String Version = "0.1";      //バージョンを定義

BLEServer* pServer;
BLECharacteristic* pCharacteristic;

//最初の処理
void setup() {
  BLESETUP();
  M5.begin(true, true, true, true);                      //m5を使うためのもの
  SPIFFS.begin();                                        //内部データを利用するための処理
  M5.Axp.ScreenBreath(100);                              // 画面の明るさを100
  M5.Lcd.setRotation(1);                                 // 画面の向きをちょうせい
  M5.Lcd.fillScreen(WHITE);                              // 背景色
  M5.Lcd.setSwapBytes(false);                            // 色がおかしい場合に変更する
  M5.Lcd.startWrite();                                   //画面表示開始
  M5.Lcd.pushImage(0, 0, imgWidth, imgHeight, logo);     //起動ロゴを表示
  M5.Lcd.setTextSize(2);                                 // テキストサイズ倍率(整数で指定)
  M5.Lcd.println("V:" + Version);                        //バージョンを表示
  Serial.println("起動しました");                        //起動時にシリアルに送信(開発用)
  delay(1000);                                           //少し待機
  M5.Lcd.endWrite();                                     //描画を一度終了します
  Serial.println("WiFiコンフィグ探知");                  //内部メモリを確認しシリアルに送信(開発用)
  WiFi.mode(WIFI_STA);                                   //WiFiの動作モードを設定
  if (SPIFFS.exists("/wifi_credentials.txt")) {          //WiFIの設定が済まされているかどうか
    Serial.println("wifi_credentials.txtが存在します");  //内部メモリを確認しシリアルに送信(開発用)
    system_status = 0;                                   //WiFiの設定が存在する場合、settingを0に設定
    connectToWiFi();
  }                                                   //if文終了
  Serial.println("コンフィグ探知終了");               //内部メモリを確認しシリアルに送信(開発用)
  if (system_status == 1) {                           //初回起動に動作させるもの
    M5.Lcd.pushImage(0, 0, imgWidth, imgHeight, QR);  //設定用のQRコードを表示
    Serial.println("ロゴ表示完了");                   //ロゴ表示完了をシリアルに送信(開発用)
    M5.Lcd.endWrite();                                //描画を一度終了します
    Serial.println("ブルートゥースを開始しました");  //ブルートゥース接続開始をシリアルに送信(開発用)
  }                                                  //if文終了
}  //void setup終了




//メインのループです
void loop() {
  M5.update();
  //初回設定用のコード
  if (system_status == 1) {  //プログラムステータス1の時に実行(void BTSettingの部分を実行します)
    BTSetting();             //ブルートゥースで初回コネクト
  }                          //if文終了

  ResetButton();
}  //void loop終了


//リセットの処理
void ResetButton() {
  if (M5.BtnC.isPressed()) {                             //ボタンの感知
    delay(10);                                           //ウェイト
    resetbutton += 1;                                    //ボタンが押されている場合は値が増加します
  } else {                                               //if文の「または~」
    if (resetbutton > 0) {                               //値が0を下回らないように
      resetbutton -= 1;                                  //ボタンが押されていない場合は値が減少します
    }                                                    //if文終了
  }                                                      //if文終了
  if (resetbutton == 300) {                              //リセットボタンの値が一定数増えたら実行
    system_status_temp = system_status;                  //システムステータスを控える
    M5.Lcd.pushImage(0, 0, imgWidth, imgHeight, reset);  //警告画面を表示
    M5.Lcd.endWrite();                                   //描画を一度終了します
    system_status = 10;                                  //システムステータスを10に
  }                                                      //if文終了
  if (system_status == 10) {                             //システムステータスが10の時に実行
    if (resetbutton > 600) {                             //リセットボタンの値が一定数増えたら実行
      M5.Lcd.setTextSize(2);                             // 文字サイズを設定
      M5.Lcd.fillScreen(TFT_BLACK);                      //黒で塗りつぶす
      M5.Lcd.println("Resetting");                       //文字列を表示
      M5.Lcd.println("It may take some time");           //文字列を表示
      M5.Lcd.println("The system will restart");         //文字列を表示
      SPIFFS.format();                                   //内部データを削除
      ESP.restart();                                     //再起動
    }                                                    //if文終了
    if (resetbutton < 290) {                             //リセットボタンの値が一定数増えたら実行
      system_status == system_status_temp;               //控えたステータスを復元
    }                                                    //if文終了
  }                                                      //if文終了
}  //void ResetButton終了



//ブルートゥースで最初のコネクトを行います
void BTSetting() {
  String receivedData = pCharacteristic->getValue().c_str();  //受け取ったデータの処理
  if (receivedData == "connect") {                            //接続先から送信された文字列が「connect」な場合に処理を実行します
    char* macAddress = getMAC();                              //WiFiのMacアドレスを取得します(char* getMACを実行します)
    pCharacteristic->setValue(macAddress);                    //接続先の危機に自身のMacアドレスを送信します
    pCharacteristic->notify();                                //接続先の危機に自身のMacアドレスを送信します
    Serial.println("コネクト");                               //ブルートゥース接続をシリアルに送信(開発用)
  }                                                           //if文終了
  if (receivedData.startsWith("SSID:") && receivedData.endsWith("Password:")) {
    // 受信したWiFi設定情報を処理
    receiveWiFiSettings(receivedData);
  }
}  //void BTSetting終了




void receiveWiFiSettings(String wifiSettings) {
  wifiSettings.remove(0, 5);  // "SSID:"の部分を削除
  wifiSettings.trim();        // 余分な空白を削除

  // カンマで分割
  int separatorIndex = wifiSettings.indexOf(',');
  if (separatorIndex != -1) {
    String ssid = wifiSettings.substring(0, separatorIndex);
    String password = wifiSettings.substring(separatorIndex + 1);

    // SPIFFSにWiFiの設定情報を保存
    saveWiFiCredentials(ssid, password);
  }
}




//内部データにWiFiのデータを書き込む
void saveWiFiCredentials(const String& ssid, const String& password) {  // SPIFFSにファイルを書き込み
  File file = SPIFFS.open("/wifi_credentials.txt", "w");                //wifi_credentials.txtというテキストに書き込みます
  if (file) {                                                           // ファイルチェック
    file.println("SSID=" + ssid);                                       // SPIFFSにファイルを書き込み
    file.println("Password=" + password);                               // SPIFFSにファイルを書き込み
    file.close();                                                       //ファイルを閉じる
    Serial.println("WiFi credentials saved successfully.");             //書き込めたことをシリアルに送信(開発用)
    system_status = 2;                                                  //プログラムステータスを2に移行
  } else {                                                              //if文の「または~」
    Serial.println("Error saving WiFi credentials to SPIFFS");          //エラーが出たときにシリアルに送信(開発用)
  }                                                                     //if文終了
}  //void saveWiFiCredentials終了




//WiFiのMacアドレスを取得します
char* getMAC() {
  uint8_t baseMac[6];                                                                                                            //WiFiのMacアドレスを取得します
  esp_read_mac(baseMac, ESP_MAC_WIFI_STA);                                                                                       //WiFiのMacアドレスを取得します
  static char baseMacChr[18] = { 0 };                                                                                            // 静的な変数として宣言
  sprintf(baseMacChr, "%02X:%02X:%02X:%02X:%02X:%02X", baseMac[0], baseMac[1], baseMac[2], baseMac[3], baseMac[4], baseMac[5]);  //WiFiのMacアドレスを取得します
  Serial.println(baseMacChr);                                                                                                    //WiFiのMacアドレスをシリアルに送信(開発用)
  return baseMacChr;                                                                                                             // baseMacChr のアドレスを返す
}  //char* getMAC終了


//WiFiに接続
void connectToWiFi() {
  String ssid;
  String password;

  // WiFi認証情報を読み取る
  readWiFiCredentials(ssid, password);
  Serial.println("SSID: " + ssid);
  Serial.println("Password: " + password);
  Serial.println("SSID Length: " + String(ssid.length()));
  Serial.println("Password Length: " + String(password.length()));

  // WiFiに接続する
  WiFi.begin(ssid, password);
  Serial.println("Connecting to WiFi...");

  int attempts = 0;
  while (WiFi.status() != WL_CONNECTED && attempts < 30) {
    delay(1000);
    Serial.println("Connecting to WiFi...");
    attempts++;
  }

  if (WiFi.status() == WL_CONNECTED) {
    Serial.println("Connected to WiFi");
    Serial.println(WiFi.localIP());
  } else {
    Serial.println("Failed to connect to WiFi");
  }
}




//WiFiの情報を内部データベースから取得
void readWiFiCredentials(String& ssid, String& password) {
  File file = SPIFFS.open("/wifi_credentials.txt", "r");

  if (file) {
    while (file.available()) {
      String line = file.readStringUntil('\n');
      line.trim();  // 行から前後の余分な空白を取り除く

      int separatorIndex = line.indexOf('=');

      if (separatorIndex != -1) {
        String key = line.substring(0, separatorIndex);
        String value = line.substring(separatorIndex + 1);

        if (key.equals("SSID")) {
          ssid = value;
        } else if (key.equals("Password")) {
          password = value;
        }
      }
    }

    file.close();
    Serial.println("WiFi credentials read successfully.");
  } else {
    Serial.println("Error reading WiFi credentials from SPIFFS");
  }
}

void BLESETUP() {
  // BLEサーバーを作成
  BLEDevice::init("BambooCOMPOST");
  pServer = BLEDevice::createServer();
  BLEService *pService = pServer->createService(BLEUUID("0000ffe0-0000-1000-8000-00805f9b34fb"));

  // BLEキャラクタリスティックを作成
  pCharacteristic = pService->createCharacteristic(BLEUUID("0000ffe1-0000-1000-8000-00805f9b34fb"), BLECharacteristic::PROPERTY_READ | BLECharacteristic::PROPERTY_WRITE);
  pCharacteristic->setValue("Hello World");

  // CCCDを有効にして通知を可能にする
  pCharacteristic->addDescriptor(new BLE2902());

  // BLEサービスを開始
  pService->start();

  // BLEアドバタイジングを開始
  BLEAdvertising *pAdvertising = BLEDevice::getAdvertising();
  pAdvertising->addServiceUUID(pService->getUUID());
  pAdvertising->start();
}